#include "MAC57D54H.h"
#include <stdio.h>
#include "m4_cache.h"
#include "halo_ports.h"
#include "illuminations.h"
#include "FSLtime.h"

#include "DCU_drv.h"
#include "QSPI.h"

#include "Display.h"
#include "mc_parameters.h"
#include "FontLibrary.h"
#include "DMAHandler.h"

#include "SM_Tables.h"
#include "SM_Global.h"
#include "SM_HLL.h"
#include "tiny_ui.h"
#include "tiny_ui_util_nOS.h"
#include "tiny_ui_platform.h"

#include "./coverflow/ALBUMS.h"

#define MC_ME_KEY 0x5AF0
#define MC_ME_INV_KEY 0xA50F

extern Graphics_Object_t IMG_GObjectArray[];

unsigned int overflow = 0;
uint16_t speed2motor(uint16_t speed);
uint16_t rpm2motor(uint16_t rpm);

extern const uint8_t IMG_Bitmap0[];
extern const void* __vector_table;
extern void sysinit();
extern void disable_wdog();
extern void ecc_init();
extern void SDRAM_setup();
void write_vtor (uint32_t vtor);
uint16_t route_interrupt (uint32_t irq, uint16_t cpu);
void set_irq_priority (uint32_t irq, uint8_t prio);
void enable_irq (uint32_t irq);
void tui_test_init_raster(void);
void testGPU(void);
void tui2go(Graphics_Object_t *dst, tiny_ui_buffer_t *src);

HLL_MotorParams_t	rMotorParams[SM_MAX_MOTORS];
SM_Err_t			eMtrErr;
SM_MotorState_t		eMtrStatus;

uint8_t bootState = 0;
int read_array[128];
int read_array2[128];
uint32_t *ptr;
uint32_t *src,*dst;
uint32_t isr_count;

void autoanimatetabs(uint32_t frame);
void physics();

uint8_t AutoAnimate = 0;

/*
Graphics_Object_t tstgpu = 
{
	0,200,200,NULL_PTR,0x00,0,GRAPHICS_565RGB,255,0,0,(GRAPHICS_CODING_RAWINT),0,0,(void *)0
};
*/

void SettleDelay(uint8_t num)
{




	uint32_t u32Timer;
	uint8_t time;
	
	for(time = 0;time < num;time++)
		for(u32Timer = 0; u32Timer < 3000000; u32Timer++);
}

void SMC_Init1(void);

int main(int argc, char *argv[])
{
	uint32_t i;
	disable_wdog();
	write_vtor((uint32_t)&__vector_table); /* configure vector table address */		
	asm(" CPSIE i"); //enable interrupts (if required)
	//m4_cache_init(CODE_CACHE);
	//m4_cache_init(SYS_CACHE);
	sysinit();
	ecc_init();
	
	#define PF3 83
	#define BACKLIGHT PF3
	SIUL2.MSCR[BACKLIGHT].B.OBE = 1;
	SIUL2.GPDO[20].B.PDO_4n3 = 1;		
	//needle_backlight_enable();
	//LED_init();
	QSPI_setup();
	
	/* DCU clock */
    MC_CGM.AC6_DC0.R = 0x80060000;	/* /7 = 91 MHz */
    MC_CGM.AC6_SC.B.SELCTL = 4;	/* Select PLL0 */
    DCU0_init(91,1);
	
	SDRAM_setup();
	
	DMA_Init();	
	DMAHR_Init();
	GALLO_Init();
	
	FLIB_SetContextDCU();
	Graphics_Init();	
	FLIB_Init();
	FLIB_Setup(MCManager_Main);    
	MCManager_Init();
	Font_Init();	
	
 
	/* Init motors */
	//SMC_Init1();	
	//eMtrErr = SM_MotorInit(SM_MOTOR_ID_1, &rMotorParams[SM_MOTOR_ID_1]);		
	//eMtrErr = SM_MotorInit(SM_MOTOR_ID_2, &rMotorParams[SM_MOTOR_ID_2]);
		
	/* Execute RTZ movement */
	//eMtrErr = SM_Rtz(SM_MOTOR_ID_1);
	//eMtrErr = SM_Rtz(SM_MOTOR_ID_2);
	
	/* Wait until RTZ complete */
	/*
	do
    {
		eMtrErr = SM_ReadMtrStatus(SM_MOTOR_ID_1, &eMtrStatus);	
    }while(eMtrStatus != SM_MOTOR_STATE_RTZ_DONE);
	
	do
    {
		eMtrErr = SM_ReadMtrStatus(SM_MOTOR_ID_2, &eMtrStatus);	
    }while(eMtrStatus != SM_MOTOR_STATE_RTZ_DONE);	
	*/
	route_interrupt(42,1);       
	set_irq_priority(42,7);
	enable_irq(42); //GPU 0
	
	route_interrupt(8,1);       
	set_irq_priority(8,6);
	enable_irq(8); //DMA 0	
	

	tui_test_init_raster();
	route_interrupt(47,1);       
	set_irq_priority(47,7);
	enable_irq(47); //GPU 0
	//testGPU();
	//test gpu failure
	//this is how the image look like
	//Display_InitLayer(0, ALBUMS_GObjectArray[0], 0, 0);
	//Display_InitLayer(1, &tstgpu, 0, 200);
	//while(1);	

	isr_count = 0;
	route_interrupt(15,1);        /* Route interrupt to primary CPU */
	set_irq_priority(15,7);
	enable_irq(15); //PIT 0

	
	init_time();	

	//while(1);
	
	// Configure movie clips
	MCManager_MClips[0] = &mc_tabs_properties;		
	MCManager_MClips[1] = &mc_base_properties;
	MCManager_MClips[2] = &mc_stage_tc_properties;	
	MCManager_MClips[3] = &mc_gps_properties;	
	MCManager_MClips[4] = &mc_cf_properties;
	MCManager_MClips[5] = &mc_video_properties;		
	MCManager_MClips[6] = &mc_doors_properties;	
	MCManager_AutoRefresh();
	MCManager_MClips[0]->run = 1;	
	
	i = 0;
  while(1) {
    FLIB_SetContextDCU();
    // Service FLIB_RenderNextFrame, each frame. This is a way
    // to do that, by checking the current state.
    if(FLIB_GetState() == FLIB_STATE_UPDATE_PENDING)
    {
      //Display_InitLayer(0, &IMG_GObjectArray[0], i, 0);

      FLIB_RenderNextFrame();    
      i++; 
	  //mc_gps_parameters.mode = 2;
	  if(i==300) AutoAnimate = 1;
	  if(AutoAnimate) autoanimatetabs(i);
	  
	  physics();
      SM_GoToPosition(SM_MOTOR_ID_2, speed2motor(mc_global_parameters.speed));
      SM_GoToPosition(SM_MOTOR_ID_1, rpm2motor(mc_global_parameters.rpm));
	  
		if(i%120 == 0){
			mc_input_parameters.wheel++;
			//mc_tabs_parameters.function = 2;
		}
		SIUL2.GPDO[10].B.PDO_4n ^= 1;	/* GPIO - Toggle LED */
	}
    if(overflow > 30){
	/* Destructive reset */
	//MC_ME_MCTL = ((unsigned int)15 << 28) | MC_ME_KEY;
	//MC_ME_MCTL = ((unsigned int)15 << 28) | MC_ME_INV_KEY;
    }
    overflow++;
 
  }	
	
	//i = MC_ME.CS.R; //should read 0x7 when all cores are active.
	
	//while(1);

	/********** interrupt example - CPU_CPU INT 0 **********/

	/*******************************************************/



    while(1);
}


int has_blitter = 0;
int has_draw = 0;
void tui_test_init_raster(void){
  tiny_ui_error_t error = 0;
  tiny_ui_platform_init_t platform_init = 
    { .sleep_func = platform_time_delay, .event_func = platform_wait_event, .int_install_func = platform_install_interrupt };
  tiny_ui_platform_init(&platform_init);
  error = tiny_ui_blit_init();
  if (error) while(1); // ugly debug stop
  error = tiny_ui_draw_init(32, 32);
  if (error) while(1); // ugly debug stop
  //reg16_write(MSCM_IRSPRC34,0x0001); // route to GPU2D to core 0 We have to do it here after having init the GPU.
  has_blitter = 1;
  has_draw = 1;
}


float current_speed = 0;
float current_gas = 0;
uint8_t gas = 0;
int current_gear = 0;

uint8_t tempe = 4;
int8_t tempedir = 1;
uint8_t fuel = 8;
int8_t fueldir = -1;
uint16_t telltale = 0;
uint8_t red_segments = 0;


//we have 5 states we will cycle
uint8_t autoanimate_state = 0;

//#define set_right_led(x)
//#define set_left_led(x,y)	
//#define set_centre_led(x)



void autoanimatetabs(uint32_t frame)
{
	//animate leds code:
	//fuel
	set_right_led(fuel);
	if(fuel>=8) fueldir = -1;
	if(fuel==0) fueldir = 1;
	//revs & tmp
	if(mc_global_parameters.rpm>=4200) red_segments = 1 + (uint8_t)((mc_global_parameters.rpm - 4200)/200);
	else red_segments = 0;
	if(red_segments>8) red_segments = 8;  
	//set_left_led(tempe, red_segments);
	set_left_led(tempe, 0);
	if(tempe>=8) tempedir = -1;
	if(tempe==0) tempedir = 1;
	//each second increment fuel and tempe
	if((frame%60) == 0){
		tempe += tempedir;
		fuel += fueldir;
	} 
	//tell tales eight symbols
	if(((frame+30)%240) == 0)  telltale ^= (1<<15);   //high beam
	if(((frame+50)%240) == 0) telltale ^= (3<<12);   //engine
	if(((frame+130)%240) == 0) telltale ^= (3<<10);   //coil
	if(((frame+160)%240) == 0) telltale ^= (1<<8);   //abs
	if(((frame+200)%240) == 0) telltale ^= (1<<6);   //steering
	if(((frame)%240) == 0) telltale ^= (1<<4);   //airbag
	if(((frame+80)%240) == 0) telltale ^= (1<<2);   //handbreak
	if(((frame+100)%240) == 0) telltale ^= (1<<0);   //park    
	set_centre_led(telltale);
    

	mc_tabs_parameters.time.h = FSLtime.m;;
	mc_tabs_parameters.time.m = FSLtime.s;
	mc_tabs_parameters.oddo = FSLtime.s * 20;
	mc_tabs_parameters.trip1 = FSLtime.s * 30;
	mc_tabs_parameters.temp = FSLtime.s * 5;
    

	mc_global_parameters.range = FSLtime.s * 11;
	mc_tabs_parameters.gear = (FSLtime.s % 4);
    
	mc_tabs_parameters.seatBelt.blink = 1;
	if(!(frame % (3*60))) mc_tabs_parameters.seatBelt.fl++; 
	if (mc_tabs_parameters.seatBelt.fl > 2)mc_tabs_parameters.seatBelt.fl = 0;
	if(!(frame % (7*60))) mc_tabs_parameters.seatBelt.fr++;
	if (mc_tabs_parameters.seatBelt.fr > 2)mc_tabs_parameters.seatBelt.fr = 0;
	if(!(frame % (11*60))) mc_tabs_parameters.seatBelt.rl++;          
	if (mc_tabs_parameters.seatBelt.rl > 2)mc_tabs_parameters.seatBelt.rl = 0;
	if(!(frame % (9*60))) mc_tabs_parameters.seatBelt.rm++;           
	if (mc_tabs_parameters.seatBelt.rm > 2)mc_tabs_parameters.seatBelt.rm = 0;
	if(!(frame % (13*60))) mc_tabs_parameters.seatBelt.rr++;
	if (mc_tabs_parameters.seatBelt.rr > 2)mc_tabs_parameters.seatBelt.rr = 0;
    
    
	if((frame%2) == 0)
    {
      if(gas == 100)
      {
        mc_global_parameters.speed++;
      }    
      if(gas == 0)
      {
        mc_global_parameters.speed--;
      }
    }
    
    if(mc_global_parameters.speed <= 0) {gas = 100; mc_global_parameters.speed = 0;}
    if(mc_global_parameters.speed >= 300){gas = 0; mc_global_parameters.speed = 300;}    
    mc_stage_tc_parameters.speed = mc_global_parameters.speed;     
    
    
    // Autoanimate rest of movieclisp
    if(!(frame % (600)))autoanimate_state++;    
    switch(autoanimate_state)
    {
      static uint16_t aa_cf;      
      case 0:
      default: 
        autoanimate_state = 0;
        aa_cf = 2;
        mc_tabs_parameters.subFunction = 0;
        mc_tabs_parameters.function = 0;
        break;
      case 1:
        mc_tabs_parameters.subFunction = 1;
        mc_tabs_parameters.function = 0;
        if(((frame+540)%600) == 0)  mc_doors_parameters.doors.boot = 1;
        if(((frame+480)%600) == 0)  mc_doors_parameters.doors.dfl = 1;
        if(((frame+420)%600) == 0)  mc_doors_parameters.doors.drl = 1;
        if(((frame+360)%600) == 0)  mc_doors_parameters.doors.drr = 1;   
        if(((frame+300)%600) == 0)  {mc_doors_parameters.doors.dfr = 1; mc_doors_parameters.doors.drl = 0;}    
        if(((frame+240)%600) == 0)  {mc_doors_parameters.doors.dfl = 0; mc_doors_parameters.doors.gas = 1;}
        if(((frame+180)%600) == 0)  mc_doors_parameters.doors.boot = 0; 
        if(((frame+120)%600) == 0)  mc_doors_parameters.doors.dfr = 0; 
        if(((frame+60)%600) == 0)   mc_doors_parameters.doors.drr = 0;  
        if(((frame+10)%600) == 0)  mc_doors_parameters.doors.gas = 0; 
        break;
      case 2:
        mc_tabs_parameters.function = 1;
        if(!(frame % (60))) mc_cf_parameters.offset+=(100*(aa_cf++/2)); 
        
        break; 
      case 3:
        mc_tabs_parameters.function = 2;
        if(!(frame % (60))) mc_input_parameters.wheel++;
        break;
      case 4:
        mc_tabs_parameters.function = 3;
        mc_gps_parameters.mode = 2;
        break;           
    }    
}




#define time_coe (0.1f)
#define  drag_coe (0.00001f)
#define  gear_coe (5.0f)
#define  break_coe (7.0f)
#define rr_coe  (0.002f)
float gear_torque[] = {5.0f,4.0f,3.0f,2.3f,1.5f,1.0f};
//float gear_speed_ratio[] = { 12.4f, 17.7f, 25.6f, 36.5f, 43.6f, 65.3f }; //speed at 1000rpm
float gear_speed_ratio[] = { 10, 20, 30, 40, 50, 60 }; //speed at 1000rpm




void physics()
{
    float rpm;
    float force;
    
    //rpm = current_speed * 1000 / gear_speed_ratio[current_gear];    
    //current_speed = mc_global_parameters.speed;
    if(gas>100) current_gas = (gas - 256.0f);
    else current_gas = gas;
    rpm = mc_global_parameters.speed * 1000 / gear_speed_ratio[current_gear];
    if (current_gas > 0)
    {
            if (rpm > (3000 + 2500 * current_gas / 100))
            {
                    current_gear++;
            }
            force = gear_torque[current_gear] * (current_gas / 100);
    }
    else
    {           
          if (current_gas == 0) current_gas = -5;
          if (current_gear>0 && rpm < 1200)
          {
                  current_gear--;
          }
          force = break_coe*current_gas/100;
    }

    //force -= (current_speed * current_speed) * drag_coe;
    //force -= current_speed * rr_coe;
    //current_speed += time_coe * force;            
    //if (current_speed < 0) current_speed = 0;
    //if (current_speed > 300) current_speed = 300;
    
    rpm = mc_global_parameters.speed * 1000 / gear_speed_ratio[current_gear];
    if (rpm < 500) rpm = 500;
    
    //mc_global_parameters.speed = (uint16_t)current_speed;
    mc_global_parameters.rpm = (uint16_t)rpm;	
    
    //mc_stage_tc_parameters.speed = mc_global_parameters.speed;
  
}

#define SMMAX   19300
uint16_t speed2motor(uint16_t speed)
{
  uint32_t spd = speed;
  if(speed<=10)
    return (1700ul*spd/10ul);
  else if(speed<=80)
    return (1700ul + ((8800ul-1700ul)*(spd-10))/70ul);
  else if(speed<=260)
    return (8800ul + ((17700ul-8800ul)*(spd-80))/180ul);
  else //if(speed<=300)
    return (17700ul + ((19300ul-17700ul)*(spd-260))/40ul);
}

uint16_t rpm2motor(uint16_t rpm)
{
  uint32_t r = rpm;
  if(r<=1000)
    return (3600ul*r/1000ul);
  else if(r<=2000)
    return (3600ul + ((7100ul-3600ul)*(r-1000))/1000ul);
  else if(r<=3000)
    return (7100ul + ((10500ul-7100ul)*(r-2000))/1000ul);
  else if(r<=4000)
    return (10500ul + ((14000ul-10500ul)*(r-3000))/1000ul);
  else if(r<=5000)
    return (14000ul + ((16700ul-14000ul)*(r-4000))/1000ul);  
  else if(r<=6000)
    return (16700ul + ((19300ul-16700ul)*(r-5000))/1000ul);
  else
    return 19300ul;

}


void SMC_Init1(void)
{
	/* Init params Motor 1 - Speed */		
	rMotorParams[SM_MOTOR_ID_1].eMtrModel			= SM_MW2000_FRONT_BASIC_CLASSIC; 	/* motor type */
	rMotorParams[SM_MOTOR_ID_1].eNominalDirection  	= SM_NOM_COUNTER_CLOCKWISE;					/* nominal direction */ 
	rMotorParams[SM_MOTOR_ID_1].eAlgoType    		= SM_ALGO_VAR_STEP_SIZE;			/* Algorithm type (only variable step size works) */
	rMotorParams[SM_MOTOR_ID_1].eUpdateTime			= SM_UPDATE_TIME_1MS1;				/* Algorithm update time */
	rMotorParams[SM_MOTOR_ID_1].u16MtrMaxVel 		= 60u;								/* Motor speed */
	rMotorParams[SM_MOTOR_ID_1].u16MtrMaxAcc 		= 42u;								/* Motor max acceleration */
	rMotorParams[SM_MOTOR_ID_1].u16MtrMaxDec 		= 42u;								/* Motor max deceleration */
	rMotorParams[SM_MOTOR_ID_1].u16DampingFactor	= 3u;								/* Motor damping factor */
	rMotorParams[SM_MOTOR_ID_1].u16Threshold1 		= 16;								/* Speed thresholds ... */
	rMotorParams[SM_MOTOR_ID_1].u16Threshold2		= 22;
	rMotorParams[SM_MOTOR_ID_1].u16Threshold3		= 28;
	rMotorParams[SM_MOTOR_ID_1].u16Threshold4		= 36;
	rMotorParams[SM_MOTOR_ID_1].u8ClockDelay		= 0;								/* PWM clock delay (doesn't work yet) */
		
	rMotorParams[SM_MOTOR_ID_1].eRtzType				= SM_RTZ_TYPE_4QUAD;			/* Rtz type (only 4quad works) */
	rMotorParams[SM_MOTOR_ID_1].eRtzStartQuad			= SM_RTZ_QUAD_0;				/* Rtz start quadrant */
	rMotorParams[SM_MOTOR_ID_1].eRtzBackEmfThreshold	= SM_RTZ_THRESHOLD_MV850;		/* BEMF threshold (enum only because of new API) */
	rMotorParams[SM_MOTOR_ID_1].u16RtzSyncStartAngle	= 96;							/* Not used now */
	rMotorParams[SM_MOTOR_ID_1].u16RtzSyncEndAngle		= 0;							/* Not used now */
	rMotorParams[SM_MOTOR_ID_1].u16RtzSyncStep			= 6;							/* Not used now */
	rMotorParams[SM_MOTOR_ID_1].u16RtzSyncStepDuration	= 1;							/* Not used now */
	rMotorParams[SM_MOTOR_ID_1].u16RtzIntegTimeUs		= 2000u;						/* Integration time */
	rMotorParams[SM_MOTOR_ID_1].u16RtzBlankTimeUs		= 10000u;						/* Blanking time */

	/* Init params Motor 2 - RPM */
	rMotorParams[SM_MOTOR_ID_2].eMtrModel			= SM_MW2000_FRONT_BASIC_CLASSIC;
	rMotorParams[SM_MOTOR_ID_2].eNominalDirection  	= SM_NOM_CLOCKWISE;
	rMotorParams[SM_MOTOR_ID_2].eAlgoType    		= SM_ALGO_VAR_STEP_SIZE;
	rMotorParams[SM_MOTOR_ID_2].eUpdateTime			= SM_UPDATE_TIME_1MS1;
	rMotorParams[SM_MOTOR_ID_2].u16MtrMaxVel 		= 60u;
	rMotorParams[SM_MOTOR_ID_2].u16MtrMaxAcc 		= 42u;
	rMotorParams[SM_MOTOR_ID_2].u16MtrMaxDec 		= 42u;
	rMotorParams[SM_MOTOR_ID_2].u16DampingFactor	= 3u;
	rMotorParams[SM_MOTOR_ID_2].u16Threshold1 		= 16;
	rMotorParams[SM_MOTOR_ID_2].u16Threshold2		= 22;
	rMotorParams[SM_MOTOR_ID_2].u16Threshold3		= 28;
	rMotorParams[SM_MOTOR_ID_2].u16Threshold4		= 36;
	rMotorParams[SM_MOTOR_ID_2].u8ClockDelay		= 0;	
		
	rMotorParams[SM_MOTOR_ID_2].eRtzType				= SM_RTZ_TYPE_4QUAD;
	rMotorParams[SM_MOTOR_ID_2].eRtzStartQuad			= SM_RTZ_QUAD_0;
	rMotorParams[SM_MOTOR_ID_2].eRtzBackEmfThreshold	= SM_RTZ_THRESHOLD_MV850;
	rMotorParams[SM_MOTOR_ID_2].u16RtzSyncStartAngle	= 96;
	rMotorParams[SM_MOTOR_ID_2].u16RtzSyncEndAngle		= 0;
	rMotorParams[SM_MOTOR_ID_2].u16RtzSyncStep			= 6;
	rMotorParams[SM_MOTOR_ID_2].u16RtzSyncStepDuration	= 1;
	rMotorParams[SM_MOTOR_ID_2].u16RtzIntegTimeUs		= 2000u;
	rMotorParams[SM_MOTOR_ID_2].u16RtzBlankTimeUs		= 10000u;
}

